// npm package: jquery-validation
// github link: https://github.com/jquery-validation/jquery-validation

'use strict';

(function () {

  // Schutzbauten : Neu
  $("#addShelter").validate({
    rules: {
      shelterName: {
        required: true,
      },
      shelterCoordinates: {
        required: true,
      },
    },
    messages: {
      shelterName: {
        required: "Es wird eine Bezeichnung für den Schutzbau benötigt",
      },
      shelterCoordinates: {
        required: "Bitte wählen Sie eine Position auf der karte",
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Zonen : Update Zone
  $("#installWizard").validate({
    rules: {
      mysql_host: {
        required: true,
      },
      mysql_port: {
        required: true,
      },
      mysql_database: {
        required: true,
      },
      mysql_username: {
        required: true,
      },
      mysql_password: {
        required: true,
      },
    },
    messages: {
      mysql_host: {
        required: "Hostname wird benötigt",
      },
      mysql_port: {
        required: "Port wird benötigt"
      },
      mysql_database: {
        required: "Datenbankname wird benötigt"
      },
      mysql_username: {
        required: "Benutzername wird benötigt"
      },
      mysql_password: {
        required: "Passwort wird benötigt"
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Zonen : Update Zone
  $("#updateZone").validate({
    rules: {
      zoneName: {
        required: true,
      },
      zoneColor: {
        required: true,
      },
    },
    messages: {
      zoneName: {
        required: "Die Zone benötigt einen Namen.",
      },
      zoneColor: {
        required: "Der Farbcode muss festgelegt sein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Zonen : Neue Zone
  $("#addZone").validate({
    rules: {
      zoneName: {
        required: true,
      },
      zoneColor: {
        required: true,
      },
    },
    messages: {
      zoneName: {
        required: "Die Zone benötigt einen Namen.",
      },
      zoneColor: {
        required: "Der Farbcode muss festgelegt sein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Sperrliste : Neuer Eintrag
  $("#newBlacklistEntry").validate({
    rules: {
      identityIDCard: {
        required: true,
        remote: {
          url: '../../api?api=blacklistCheckIDCard',
          type: 'POST',
          data: {
            identityIDCard: function () {
              return $("#identityIDCard").val();
            }
          }
        }
      },
      identitySurname: {
        required: true,
      },
      identityGivenname: {
        required: true,
      },
    },
    messages: {
      identityIDCard: {
        required: "Bitte geben Sie eine Ausweisnummer ein.",
        remote: "Es ist bereits ein Eintrag mit diesem Ausweis vorhanden."
      },
      identitySurname: {
        required: "Bitte geben Sie den Nachnamen ein.",
      },
      identityGivenname: {
        required: "Bitte geben Sie den Vornamen ein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Sperrliste : Eintrag Bearbeiten
  $("#updateBlacklistEntry").validate({
    rules: {
      identityIDCard: {
        required: false,
        remote: {
          url: '../../api?api=blacklistCheckIDCard',
          type: 'POST',
          data: {
            identityIDCard: function () {
              return $("#identityIDCard").val();
            }
          }
        }
      },
      identitySurname: {
        required: true,
      },
      identityGivenname: {
        required: true,
      },
    },
    messages: {
      identityIDCard: {
        required: "Bitte geben Sie eine Ausweisnummer ein.",
        remote: "Es ist bereits ein Eintrag mit diesem Ausweis vorhanden."
      },
      identitySurname: {
        required: "Bitte geben Sie den Nachnamen ein.",
      },
      identityGivenname: {
        required: "Bitte geben Sie den Vornamen ein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });


  // Neue Identität: Soldaten
  $("#newIdentityMilitary").validate({
    rules: {
      identitySurname: {
        required: true,
      },
      identityGivenname: {
        required: true,
      },
      identityIN: {
        required: true,
      },
      identityOUT: {
        required: true,
      },
    },
    messages: {
      identitySurname: {
        required: "Bitte geben Sie den Nachnamen ein."
      },
      identityGivenname: {
        required: "Bitte geben Sie den Vornamen ein."
      },
      identityIN: {
        required: "Bitte geben Sie das IN-Datum ein."
      },
      identityOUT: {
        required: "Bitte geben Sie das geplante OUT-Datum ein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Neue Identität: Gast
  $("#newIdentityGuest").validate({
    rules: {
      identitySurname: {
        required: true,
      },
      identityGivenname: {
        required: true,
      },
      identityIN: {
        required: true,
      },
      identityOUT: {
        required: true,
      },
    },
    messages: {
      identitySurname: {
        required: "Bitte geben Sie den Nachnamen ein."
      },
      identityGivenname: {
        required: "Bitte geben Sie den Vornamen ein."
      },
      identityIN: {
        required: "Bitte geben Sie ein Zeitraum ein."
      },
      identityOUT: {
        required: "Bitte geben Sie ein Zeitraum ein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Neue Identität: Ortskräfte
  $("#newIdentityLocal").validate({
    rules: {
      identitySurname: {
        required: true,
      },
      identityGivenname: {
        required: true,
      },
      identityIN: {
        required: true,
      },
      identityOUT: {
        required: true,
      },
      identityIDCard: {
        required: true,
        remote: {
          url: '../../api?api=blacklistCheckIDCard',
          type: 'POST',
          data: {
            identityIDCard: function () {
              return $("#identityIDCard").val();
            }
          }
        }
      },
    },
    messages: {
      identityIDCard: {
        required: "Bitte geben Sie eine Ausweisnummer ein.",
        remote: "Die Person befindet sich auf der Sperrliste!"
      },
      identitySurname: {
        required: "Bitte geben Sie den Nachnamen ein."
      },
      identityGivenname: {
        required: "Bitte geben Sie den Vornamen ein."
      },
      identityIN: {
        required: "Bitte geben Sie ein Zeitraum ein."
      },
      identityOUT: {
        required: "Bitte geben Sie ein Zeitraum ein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Edit: Dienstposten - Militärisch
  $("#editPositionMilitary").validate({
    rules: {
      positionID: {
        required: false,
        minlength: 4,
        remote: {
          url: '../../api?api=isPositionIDAvailable',
          type: 'POST',
          data: {
            positionID: function () {
              return $("#positionID").val();
            }
          }
        }
      },
      positionAccessCard: {
        required: false,
        minlength: 3,
        remote: {
          url: '../../api?api=isAccessCardAvailable',
          type: 'POST',
          data: {
            positionID: function () {
              return $("#positionAccessCard").val();
            }
          }
        }
      },
      positionName: {
        required: true,
      },
      positionDepartment: {
        required: true,
      },
    },
    messages: {
      positionID: {
        required: "Bitte geben Sie eine Dienstposten-ID ein.",
        minlength: "Bitte geben Sie mindestens 4 Zeichen ein",
        remote: "Es ist bereits ein Dienstposten mit dieser ID vorhanden."
      },
      positionAccessCard: {
        required: "Bitte geben Sie eine Karten-ID ein.",
        minlength: "Bitte geben Sie mindestens 3 Zeichen ein",
        remote: "Es ist bereits ein Zutrittskarte mit dieser ID vorhanden."
      },
      positionName: {
        required: "Bitte geben Sie eine Bezeichnung ein."
      },
      positionDepartment: {
        required: "Bitte geben Sie Dienststelle ein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Edit: Dienstposten - Zivil
  $("#editPositionCivil").validate({
    rules: {
      positionID: {
        required: false,
        minlength: 4,
        remote: {
          url: '../../api?api=isPositionIDAvailable',
          type: 'POST',
          data: {
            positionID: function () {
              return $("#positionID").val();
            }
          }
        }
      },
      positionAccessCard: {
        required: false,
        minlength: 3,
        remote: {
          url: '../../api?api=isAccessCardAvailable',
          type: 'POST',
          data: {
            positionID: function () {
              return $("#positionAccessCard").val();
            }
          }
        }
      },
      positionName: {
        required: true,
      },
      positionDepartment: {
        required: true,
      },
    },
    messages: {
      positionID: {
        required: "Bitte geben Sie eine Dienstposten-ID ein.",
        minlength: "Bitte geben Sie mindestens 4 Zeichen ein",
        remote: "Es ist bereits ein Dienstposten mit dieser ID vorhanden."
      },
      positionAccessCard: {
        required: "Bitte geben Sie eine Karten-ID ein.",
        minlength: "Bitte geben Sie mindestens 3 Zeichen ein",
        remote: "Es ist bereits ein Zutrittskarte mit dieser ID vorhanden."
      },
      positionName: {
        required: "Bitte geben Sie eine Bezeichnung ein."
      },
      positionDepartment: {
        required: "Bitte geben Sie Dienststelle ein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Edit: Dienstposten - Ortskräfte
  $("#editPositionLocal").validate({
    rules: {
      positionID: {
        required: false,
        minlength: 4,
        remote: {
          url: '../../api?api=isPositionIDAvailable',
          type: 'POST',
          data: {
            positionID: function () {
              return $("#positionID").val();
            }
          }
        }
      },
      positionName: {
        required: true,
      },
      positionDepartment: {
        required: true,
      },
    },
    messages: {
      positionID: {
        required: "Bitte geben Sie eine Dienstposten-ID ein.",
        minlength: "Bitte geben Sie mindestens 4 Zeichen ein",
        remote: "Es ist bereits ein Dienstposten mit dieser ID vorhanden."
      },
      positionName: {
        required: "Bitte geben Sie eine Bezeichnung ein."
      },
      positionDepartment: {
        required: "Bitte geben Sie Dienststelle ein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Edit: Dienstposten - Gäste
  $("#editPositionGuest").validate({
    rules: {
      positionID: {
        required: false,
        minlength: 4,
        remote: {
          url: '../../api?api=isPositionIDAvailable',
          type: 'POST',
          data: {
            positionID: function () {
              return $("#positionID").val();
            }
          }
        }
      },
      positionName: {
        required: true,
      },
      positionDepartment: {
        required: true,
      },
    },
    messages: {
      positionID: {
        required: "Bitte geben Sie eine Dienstposten-ID ein.",
        minlength: "Bitte geben Sie mindestens 4 Zeichen ein",
        remote: "Es ist bereits ein Dienstposten mit dieser ID vorhanden."
      },
      positionName: {
        required: "Bitte geben Sie eine Bezeichnung ein."
      },
      positionDepartment: {
        required: "Bitte geben Sie Dienststelle ein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Neuer Dienstposten
  $("#newPosition").validate({
    rules: {
      positionID: {
        required: true,
        minlength: 4,
        remote: {
          url: '../../api?api=isPositionIDAvailable',
          type: 'POST',
          data: {
            positionID: function () {
              return $("#positionID").val();
            }
          }
        }
      },
      positionName: {
        required: true,
      },
      positionDepartment: {
        required: true,
      },
    },
    messages: {
      positionID: {
        required: "Bitte geben Sie eine Dienstposten-ID ein.",
        minlength: "Bitte geben Sie mindestens 4 Zeichen ein",
        remote: "Es ist bereits ein Dienstposten mit dieser ID vorhanden."
      },
      positionName: {
        required: "Bitte geben Sie eine Bezeichnung ein."
      },
      positionDepartment: {
        required: "Bitte geben Sie Dienststelle ein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Neuer Dienstposten: Gast
  $("#newPositionGuest").validate({
    rules: {
      positionID: {
        required: true,
        minlength: 4,
        remote: {
          url: '../../api?api=isPositionIDAvailable',
          type: 'POST',
          data: {
            positionID: function () {
              return $("#positionID").val();
            }
          }
        }
      },
      positionAccessCard: {
        required: true,
        minlength: 3,
        remote: {
          url: '../../api?api=isAccessCardAvailable',
          type: 'POST',
          data: {
            positionID: function () {
              return $("#positionAccessCard").val();
            }
          }
        }
      },
      positionName: {
        required: true,
      },
      positionDepartment: {
        required: true,
      },
    },
    messages: {
      positionID: {
        required: "Bitte geben Sie eine Dienstposten-ID ein.",
        minlength: "Bitte geben Sie mindestens 4 Zeichen ein",
        remote: "Es ist bereits ein Dienstposten mit dieser ID vorhanden."
      },
      positionAccessCard: {
        required: "Bitte geben Sie eine Karten-ID ein.",
        minlength: "Bitte geben Sie mindestens 3 Zeichen ein",
        remote: "Es ist bereits ein Zutrittskarte mit dieser ID vorhanden."
      },
      positionName: {
        required: "Bitte geben Sie eine Bezeichnung ein."
      },
      positionDepartment: {
        required: "Bitte geben Sie Dienststelle ein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Neuer Dienstposten: Local
  $("#newPositionLocal").validate({
    rules: {
      positionID: {
        required: true,
        minlength: 4,
        remote: {
          url: '../../api?api=isPositionIDAvailable',
          type: 'POST',
          data: {
            positionID: function () {
              return $("#positionID").val();
            }
          }
        }
      },
      positionAccessCard: {
        required: true,
        minlength: 3,
        remote: {
          url: '../../api?api=isAccessCardAvailable',
          type: 'POST',
          data: {
            positionID: function () {
              return $("#positionAccessCard").val();
            }
          }
        }
      },
      positionName: {
        required: true,
      },
      positionDepartment: {
        required: true,
      },
    },
    messages: {
      positionID: {
        required: "Bitte geben Sie eine Dienstposten-ID ein.",
        minlength: "Bitte geben Sie mindestens 4 Zeichen ein",
        remote: "Es ist bereits ein Dienstposten mit dieser ID vorhanden."
      },
      positionAccessCard: {
        required: "Bitte geben Sie eine Karten-ID ein.",
        minlength: "Bitte geben Sie mindestens 3 Zeichen ein",
        remote: "Es ist bereits ein Zutrittskarte mit dieser ID vorhanden."
      },
      positionName: {
        required: "Bitte geben Sie eine Bezeichnung ein."
      },
      positionDepartment: {
        required: "Bitte geben Sie Dienststelle ein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Neuer Dienstposten: Civil
  $("#newPositionCivil").validate({
    rules: {
      positionID: {
        required: true,
        minlength: 4,
        remote: {
          url: '../../api?api=isPositionIDAvailable',
          type: 'POST',
          data: {
            positionID: function () {
              return $("#positionID").val();
            }
          }
        }
      },
      positionAccessCard: {
        required: true,
        minlength: 3,
        remote: {
          url: '../../api?api=isAccessCardAvailable',
          type: 'POST',
          data: {
            positionID: function () {
              return $("#positionAccessCard").val();
            }
          }
        }
      },
      positionName: {
        required: true,
      },
      positionDepartment: {
        required: true,
      },
    },
    messages: {
      positionID: {
        required: "Bitte geben Sie eine Dienstposten-ID ein.",
        minlength: "Bitte geben Sie mindestens 4 Zeichen ein",
        remote: "Es ist bereits ein Dienstposten mit dieser ID vorhanden."
      },
      positionAccessCard: {
        required: "Bitte geben Sie eine Karten-ID ein.",
        minlength: "Bitte geben Sie mindestens 3 Zeichen ein",
        remote: "Es ist bereits ein Zutrittskarte mit dieser ID vorhanden."
      },
      positionName: {
        required: "Bitte geben Sie eine Bezeichnung ein."
      },
      positionDepartment: {
        required: "Bitte geben Sie Dienststelle ein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  // Neuer Dienstposten: Militärisch
  $("#newPositionMilitary").validate({
    rules: {
      positionID: {
        required: true,
        minlength: 4,
        remote: {
          url: '../../api?api=isPositionIDAvailable',
          type: 'POST',
          data: {
            positionID: function () {
              return $("#positionID").val();
            }
          }
        }
      },
      positionAccessCard: {
        required: true,
        minlength: 3,
        remote: {
          url: '../../api?api=isAccessCardAvailable',
          type: 'POST',
          data: {
            positionID: function () {
              return $("#positionAccessCard").val();
            }
          }
        }
      },
      positionName: {
        required: true,
      },
      positionDepartment: {
        required: true,
      },
    },
    messages: {
      positionID: {
        required: "Bitte geben Sie eine Dienstposten-ID ein.",
        minlength: "Bitte geben Sie mindestens 4 Zeichen ein",
        remote: "Es ist bereits ein Dienstposten mit dieser ID vorhanden."
      },
      positionAccessCard: {
        required: "Bitte geben Sie eine Karten-ID ein.",
        minlength: "Bitte geben Sie mindestens 3 Zeichen ein",
        remote: "Es ist bereits ein Zutrittskarte mit dieser ID vorhanden."
      },
      positionName: {
        required: "Bitte geben Sie eine Bezeichnung ein."
      },
      positionDepartment: {
        required: "Bitte geben Sie Dienststelle ein."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  $("#newAccessCard").validate({
    rules: {
      accessCardPIC: {
        required: true,
        minlength: 3,
        maxlength: 4,
        remote: {
          url: '../../api?api=isPICNumberAvailable',
          type: 'POST',
          data: {
            accessCardPIC: function () {
              return $("#accessCardPIC").val();
            }
          }
        }
      },
    },
    messages: {
      accessCardPIC: {
        required: "Bitte geben Sie eine PIC-Nummer ein.",
        remote: "Es ist bereits eine Zutrittskarte mit dieser Nummer vorhanden.",
        minlength: "Mindestens 3 Zeichen.",
        maxlength: "Maximal 4 Zeichen."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  $("#newAccount").validate({
    rules: {
      accountUsername: {
        required: true,
        minlength: 4,
        remote: {
          url: '../../api?api=isUsernameAvailable',
          type: 'POST',
          data: {
            accountUsername: function () {
              return $("#accountUsername").val();
            }
          }
        }
      },
      accountPassword: {
        required: true,
        minlength: 6
      },
      accountDisplayName: {
        required: true,
        minlength: 4
      },
    },
    messages: {
      accountUsername: {
        required: "Bitte geben Sie den Benutzernamen ein.",
        remote: "Ein Benutzerkonto mit diesem Benutzernamen ist bereits vorhanden.",
        minlength: "Der Benutzername muss aus mindestens 4 Zeichen bestehen."
      },
      accountPassword: {
        required: "Bitte vergeben Sie ein Passwort für das Benutzerkonto.",
        minlength: "Das Passwort muss aus mindestens 6 Zeichen bestehen."
      },
      accountDisplayName: {
        required: "Bitte geben Sie den vollständigen Namen ein.",
        minlength: "Der Name muss aus mindestens 4 Zeichen bestehen."
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  $("#editPassword").validate({
    rules: {
      current_password: {
        required: true,
        remote: {
          url: '../../api?api=validatePassword',
          type: 'POST',
          data: {
            current_password: function () {
              return $("#current_password").val();
            }
          }
        }
      },
      password: {
        required: true,
        minlength: 14
      },
      confirm_password: {
        required: true,
        minlength: 14,
        equalTo: "#password"
      },
    },
    messages: {
      current_password: {
        required: "Bitte gebe dein aktuelles Passwort ein",
        remote: "Das eingegebene Passwort ist nicht korrekt"
      },
      password: {
        required: "Bitte gebe ein neues Passwort ein",
        minlength: "Das Passwort muss mindestens 14 Zeichen lang sein"
      },
      confirm_password: {
        required: "Bitte bestätige dein Passwort",
        minlength: "Das Passwort muss mindestens 14 Zeichen lang sein",
        equalTo: "Bitte gebe das gleiche Passwort wie oben ein"
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

  $("#editProfile").validate({
    rules: {
      displayName: {
        required: true,
        minlength: 4
      },
    },
    messages: {
      displayName: {
        required: "Bitte geben deinen vollständigen Namen ein",
        minlength: "Der Name muss aus mindestens 4 Zeichen bestehen"
      },
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });



  // validate signup form on keyup and submit
  $("#signupForm").validate({
    rules: {
      name: {
        required: true,
        minlength: 3
      },
      email: {
        required: true,
        email: true
      },
      age_select: {
        required: true
      },
      gender_radio: {
        required: true
      },
      skill_check: {
        required: true
      },
      password: {
        required: true,
        minlength: 5
      },
      confirm_password: {
        required: true,
        minlength: 5,
        equalTo: "#password"
      },
      terms_agree: "required"
    },
    messages: {
      name: {
        required: "Please enter a name",
        minlength: "Name must consist of at least 3 characters"
      },
      email: "Please enter a valid email address",
      age_select: "Please select your age",
      skill_check: "Please select your skills",
      gender_radio: "Please select your gender",
      password: {
        required: "Please provide a password",
        minlength: "Your password must be at least 5 characters long"
      },
      confirm_password: {
        required: "Please confirm your password",
        minlength: "Your password must be at least 5 characters long",
        equalTo: "Please enter the same password as above"
      },
      terms_agree: "Please agree to terms and conditions"
    },
    errorPlacement: function (error, element) {
      error.addClass("invalid-feedback");

      if (element.parent('.input-group').length) {
        error.insertAfter(element.parent());
      }
      else if (element.prop('type') === 'radio' && element.parent('.radio-inline').length) {
        error.insertAfter(element.parent().parent());
      }
      else if (element.prop('type') === 'checkbox' || element.prop('type') === 'radio') {
        error.appendTo(element.parent().parent());
      }
      else {
        error.insertAfter(element);
      }
    },
    highlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-invalid").removeClass("is-valid");
      }
    },
    unhighlight: function (element, errorClass) {
      if ($(element).prop('type') != 'checkbox' && $(element).prop('type') != 'radio') {
        $(element).addClass("is-valid").removeClass("is-invalid");
      }
    }
  });

})();